/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.lspeed;

import ibm.nways.jdm.RemoteStatus;
import ibm.nways.jdm.Status;
import ibm.nways.jdm.StatusProxy;
import ibm.nways.jdm.Watchable;
import ibm.nways.jdm.WatchableImpl;
import ibm.nways.jdm.Watcher;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.lspeed.model.LsPortModel;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class LsBridgeConfig
extends WatchableImpl
implements Watcher {
    private static String bundleName = "ibm.nways.lspeed.LsGeneralResources";
    private static String NlsInvalidBridgeName = "InvalidBridgeName";
    private static String NlsUnassignedBridgeName = "UnassignedBridgeName";
    private static ResourceBundle lspeedBundle = null;
    private static ResourceBundle enumStrings = null;
    private GenModel deviceModel;
    private GenModel bridgeTableModel;
    private GenModel bridgePortModel;
    private GenModel bridgeMonitorModel;
    private Vector bridgeMonitorProxyList;
    private Thread refreshThread;
    private Thread buildDependentsThread;
    private boolean refreshInProgress = true;
    private Vector bridgesList = new Vector();
    private Vector bridgePortsList;

    private static ResourceBundle getLspeedBundle() {
        return lspeedBundle;
    }

    private static ResourceBundle getEnumStrings() {
        return enumStrings;
    }

    private GenModel getBridgeTableModel() {
        return this.bridgeTableModel;
    }

    private GenModel getDevicePortModel() {
        return this.bridgePortModel;
    }

    private boolean getRefreshInProgress() {
        return this.refreshInProgress;
    }

    private void setRefreshInProgress(boolean bl) {
        this.refreshInProgress = bl;
    }

    private void setBridgesList(Vector vector) {
        this.bridgesList = vector;
        this.setChanged();
        this.notifyWatchers();
    }

    public LsBridgeConfig(GenModel genModel) {
        this.deviceModel = genModel;
        if (genModel != null) {
            try {
                this.bridgeTableModel = (GenModel)genModel.getComponent("LsBridgeTable");
                this.bridgePortModel = (GenModel)genModel.getComponent("LsPort");
                this.bridgeMonitorModel = (GenModel)genModel.getComponent("LsBridgeMonitor");
                this.checkProxyList();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (lspeedBundle == null) {
            lspeedBundle = ResourceBundle.getBundle(bundleName);
        }
        if (enumStrings == null) {
            enumStrings = ResourceBundle.getBundle("ibm.nways.lspeed.eui.EnumeratedResources");
        }
    }

    private void checkProxyList() {
        boolean bl = true;
        if (this.bridgeMonitorProxyList != null) {
            try {
                Vector vector = this.bridgeMonitorModel.getRestOfInfo("_Empty", "default", null, null);
                if (vector != null && vector.size() == this.bridgeMonitorProxyList.size()) {
                    bl = false;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (bl && (this.buildDependentsThread == null || this.buildDependentsThread != null && !this.buildDependentsThread.isAlive())) {
            this.buildDependentsThread = new BuildDependentsThread();
            this.buildDependentsThread.start();
        }
    }

    private void buildProxyList() {
        try {
            if (this.bridgeMonitorProxyList != null) {
                int n = 0;
                while (n < this.bridgeMonitorProxyList.size()) {
                    Status status = (Status)this.bridgeMonitorProxyList.elementAt(n);
                    status.deleteWatcher(this);
                    ++n;
                }
                this.bridgeMonitorProxyList.removeAllElements();
            } else {
                this.bridgeMonitorProxyList = new Vector();
            }
            if (this.bridgeMonitorModel != null) {
                Vector vector = this.bridgeMonitorModel.getRestOfInfo("_Empty", "default", null, null);
                int n = 0;
                while (n < vector.size()) {
                    ModelInfo modelInfo = (ModelInfo)vector.elementAt(n);
                    RemoteStatus remoteStatus = this.bridgeMonitorModel.getStatusRefForRow(modelInfo);
                    if (remoteStatus != null) {
                        StatusProxy statusProxy = new StatusProxy(remoteStatus);
                        this.bridgeMonitorProxyList.addElement(statusProxy);
                        statusProxy.addWatcher(this);
                    }
                    ++n;
                }
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dispose() {
        if (this.bridgeMonitorProxyList != null) {
            try {
                int n = 0;
                while (n < this.bridgeMonitorProxyList.size()) {
                    Status status = (Status)this.bridgeMonitorProxyList.elementAt(n);
                    status.deleteWatcher(this);
                    ++n;
                }
                this.bridgeMonitorProxyList.removeAllElements();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    public void update(Watchable watchable, Object object) {
        if (!this.getRefreshInProgress()) {
            this.setRefreshInProgress(true);
            this.checkProxyList();
            this.refresh();
        }
    }

    public void refresh() {
        if (this.refreshThread != null) {
            this.refreshThread.stop();
        }
        this.refreshThread = new RefreshThread();
        this.setRefreshInProgress(true);
        this.refreshThread.start();
    }

    public Vector getBridgesList() {
        return this.bridgesList;
    }

    public Vector getAllBridgePorts() {
        return this.bridgePortsList;
    }

    public int getNextAvailBridgeId() {
        int n = 0;
        int n2 = 1;
        while (n2 <= 240) {
            if (this.getBridge(n2) == null) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public LsBridgeObject getBridge(int n) {
        LsBridgeObject lsBridgeObject = null;
        Enumeration enumeration = this.bridgesList.elements();
        while (enumeration.hasMoreElements() && lsBridgeObject == null) {
            LsBridgeObject lsBridgeObject2 = (LsBridgeObject)enumeration.nextElement();
            if (lsBridgeObject2.getBridgeId() != n) continue;
            lsBridgeObject = lsBridgeObject2;
        }
        return lsBridgeObject;
    }

    public LsBridgePortObject getBridgePortObjectForIfIndex(int n, int n2) {
        LsBridgePortObject lsBridgePortObject = null;
        boolean bl = false;
        Enumeration enumeration = this.bridgesList.elements();
        while (enumeration.hasMoreElements() && !bl) {
            LsBridgeObject lsBridgeObject = (LsBridgeObject)enumeration.nextElement();
            Enumeration enumeration2 = lsBridgeObject.getBridgePorts().elements();
            while (enumeration2.hasMoreElements() && !bl) {
                LsBridgePortObject lsBridgePortObject2 = (LsBridgePortObject)enumeration2.nextElement();
                if (lsBridgePortObject2.getIfIndex() != n2 || lsBridgePortObject2.getPortType() == 6 && lsBridgePortObject2.getVBridgeId() != n) continue;
                bl = true;
                lsBridgePortObject = lsBridgePortObject2;
            }
        }
        return lsBridgePortObject;
    }

    public LsBridgePortObject getBridgePortObjectForSlotPort(int n, int n2) {
        LsBridgePortObject lsBridgePortObject = null;
        boolean bl = false;
        Enumeration enumeration = this.bridgesList.elements();
        while (enumeration.hasMoreElements() && !bl) {
            LsBridgeObject lsBridgeObject = (LsBridgeObject)enumeration.nextElement();
            Enumeration enumeration2 = lsBridgeObject.getBridgePorts().elements();
            while (enumeration2.hasMoreElements() && !bl) {
                LsBridgePortObject lsBridgePortObject2 = (LsBridgePortObject)enumeration2.nextElement();
                if (lsBridgePortObject2.getSlot() != n || lsBridgePortObject2.getPort() != n2) continue;
                bl = true;
                lsBridgePortObject = lsBridgePortObject2;
            }
        }
        return lsBridgePortObject;
    }

    public boolean portMoved(LsBridgePortObject lsBridgePortObject, int n) {
        boolean bl = false;
        LsBridgeObject lsBridgeObject = this.getBridge(n);
        if (lsBridgeObject == null || lsBridgePortObject == null) {
            bl = true;
            this.refresh();
        } else {
            LsBridgeObject lsBridgeObject2 = lsBridgePortObject.getParentBridge();
            lsBridgeObject2.removeBridgePort(lsBridgePortObject);
            if (lsBridgeObject2.getNumOfPorts() == 0) {
                this.bridgesList.removeElement(lsBridgeObject2);
                bl = true;
            }
            lsBridgeObject.addBridgePort(lsBridgePortObject);
            this.setChanged();
            this.notifyWatchers();
        }
        return bl;
    }

    private Vector buildBridgesLogicalView() {
        Vector vector = null;
        Vector vector2 = null;
        Vector<LsBridgeObject> vector3 = new Vector<LsBridgeObject>();
        Vector<LsBridgePortObject> vector4 = new Vector<LsBridgePortObject>();
        if (this.bridgeTableModel == null || this.bridgePortModel == null) {
            return null;
        }
        LsBridgeObject lsBridgeObject = new LsBridgeObject(lspeedBundle.getString(NlsUnassignedBridgeName), 256);
        LsBridgeObject lsBridgeObject2 = new LsBridgeObject(lspeedBundle.getString(NlsInvalidBridgeName), 0);
        try {
            vector = this.bridgeTableModel.getRestOfInfo("VBridgeTableEntry", "default", null, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (vector != null) {
            Object object;
            LsBridgeObject lsBridgeObject3;
            int n;
            ModelInfo modelInfo = null;
            ModelInfo modelInfo2 = null;
            Serializable serializable = null;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                modelInfo = (ModelInfo)enumeration.nextElement();
                if (!(modelInfo.get("VBridgeTableEntry.VBridgeId") instanceof Integer) || (n = ((Integer)modelInfo.get("VBridgeTableEntry.VBridgeId")).intValue()) > 240) continue;
                lsBridgeObject3 = new LsBridgeObject(n);
                vector3.addElement(lsBridgeObject3);
                try {
                    object = lsBridgeObject3.getBridgeExtsModel();
                    if (object == null || !((serializable = (modelInfo2 = object.getInfo("LsBridgeGenInfo")).get("LsBridgeGenInfo.BridgeName")) instanceof String)) continue;
                    lsBridgeObject3.setBridgeName((String)((Object)serializable));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            try {
                vector2 = this.bridgePortModel.getRestOfInfo("BridgePortSumm", "default", null, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            object = vector2.elements();
            while (object.hasMoreElements()) {
                modelInfo = (ModelInfo)object.nextElement();
                LsBridgePortObject lsBridgePortObject = new LsBridgePortObject(null, modelInfo);
                vector4.addElement(lsBridgePortObject);
                if (!(modelInfo.get("BridgePortSumm.BPortVBridge") instanceof Integer)) continue;
                n = (Integer)modelInfo.get("BridgePortSumm.BPortVBridge");
                if (n == 256) {
                    lsBridgeObject.addBridgePort(lsBridgePortObject);
                    continue;
                }
                lsBridgeObject3 = this.findBridgeObj(n, vector3);
                if (lsBridgeObject3 != null) {
                    lsBridgeObject3.addBridgePort(lsBridgePortObject);
                    continue;
                }
                lsBridgeObject2.addBridgePort(lsBridgePortObject);
            }
        }
        vector3.addElement(lsBridgeObject);
        vector3.addElement(lsBridgeObject2);
        this.bridgePortsList = vector4;
        return vector3;
    }

    private LsBridgeObject findBridgeObj(int n, Vector vector) {
        LsBridgeObject lsBridgeObject = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LsBridgeObject lsBridgeObject2 = (LsBridgeObject)enumeration.nextElement();
            if (lsBridgeObject2.getBridgeId() != n) continue;
            lsBridgeObject = lsBridgeObject2;
            break;
        }
        return lsBridgeObject;
    }

    final /* synthetic */ GenModel access$1() {
        return this.getDevicePortModel();
    }

    final /* synthetic */ Vector access$2() {
        return this.buildBridgesLogicalView();
    }

    final /* synthetic */ void access$3(Vector vector) {
        this.setBridgesList(vector);
    }

    final /* synthetic */ void access$4(boolean bl) {
        this.setRefreshInProgress(bl);
    }

    final /* synthetic */ void access$5() {
        this.buildProxyList();
    }

    final /* synthetic */ GenModel access$6() {
        return this.getBridgeTableModel();
    }

    public class LsBridgeObject {
        private int bridgeId;
        private String bridgeName;
        private Vector bridgePortInfos;
        private GenModel bridgeExtsModel;
        private GenModel bridgePortExtsModel;
        private GenModel bridgeModel;

        protected LsBridgeObject(int n) {
            this("Bridge " + n, n);
        }

        protected LsBridgeObject(String string, int n) {
            LsBridgeConfig.this = LsBridgeConfig.this;
            this.bridgeName = string;
            this.bridgeId = n;
            this.bridgePortInfos = new Vector();
        }

        protected void addBridgePort(LsBridgePortObject lsBridgePortObject) {
            lsBridgePortObject.setParentBridge(this);
            lsBridgePortObject.setVBridgeId(this.bridgeId);
            this.bridgePortInfos.addElement(lsBridgePortObject);
        }

        protected void removeBridgePort(LsBridgePortObject lsBridgePortObject) {
            this.bridgePortInfos.removeElement(lsBridgePortObject);
        }

        public int getBridgeId() {
            return this.bridgeId;
        }

        public String getBridgeName() {
            return this.bridgeName;
        }

        public void setBridgeName(String string) {
            this.bridgeName = string;
        }

        public int getNumOfPorts() {
            return this.bridgePortInfos.size();
        }

        public Vector getBridgePorts() {
            return this.bridgePortInfos;
        }

        public boolean hasValidId() {
            return this.bridgeId > 0 && this.bridgeId < 240;
        }

        public GenModel getBridgeExtsModel() {
            block2: {
                if (this.bridgeExtsModel != null || !this.hasValidId()) break block2;
                try {
                    ModelInfo modelInfo = new ModelInfo();
                    modelInfo.add("Index.VBridgeId", new Integer(this.bridgeId));
                    GenModel genModel = LsBridgeConfig.this.access$6().getRowRef(modelInfo);
                    GenModel genModel2 = (GenModel)genModel.getComponent("LsBridge");
                    this.bridgeExtsModel = (GenModel)genModel2.getComponent("LsBridgeExts");
                    this.bridgePortExtsModel = (GenModel)genModel2.getComponent("LsBridgePortExts");
                    this.bridgeModel = genModel2;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return this.bridgeExtsModel;
        }

        public GenModel getBridgePortExtsModel() {
            block2: {
                if (this.bridgePortExtsModel != null || !this.hasValidId()) break block2;
                try {
                    ModelInfo modelInfo = new ModelInfo();
                    modelInfo.add("Index.VBridgeId", new Integer(this.bridgeId));
                    GenModel genModel = LsBridgeConfig.this.access$6().getRowRef(modelInfo);
                    GenModel genModel2 = (GenModel)genModel.getComponent("LsBridge");
                    this.bridgeExtsModel = (GenModel)genModel2.getComponent("LsBridgeExts");
                    this.bridgePortExtsModel = (GenModel)genModel2.getComponent("LsBridgePortExts");
                    this.bridgeModel = genModel2;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return this.bridgePortExtsModel;
        }

        public GenModel getBridgeModel() {
            block2: {
                if (this.bridgeModel != null || !this.hasValidId()) break block2;
                try {
                    ModelInfo modelInfo = new ModelInfo();
                    modelInfo.add("Index.VBridgeId", new Integer(this.bridgeId));
                    GenModel genModel = LsBridgeConfig.this.access$6().getRowRef(modelInfo);
                    this.bridgeModel = (GenModel)genModel.getComponent("LsBridge");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return this.bridgeModel;
        }
    }

    public class LsBridgePortObject {
        private int slot;
        private int port;
        private int ifIndex;
        private int vbridgeId;
        private int portType = 1;
        private int stpState;
        private LsBridgeObject parent;
        private StatusProxy portStatus;
        private String key;

        protected LsBridgePortObject(LsBridgeObject lsBridgeObject, ModelInfo modelInfo) {
            LsBridgeConfig.this = LsBridgeConfig.this;
            this.parent = lsBridgeObject;
            Serializable serializable = modelInfo.get("Index.Slot");
            if (serializable instanceof Integer) {
                this.slot = (Integer)serializable;
            }
            if ((serializable = modelInfo.get("Index.Port")) instanceof Integer) {
                this.port = (Integer)serializable;
            }
            if ((serializable = modelInfo.get("BridgePortSumm.BPortIfIndex")) instanceof Integer) {
                this.ifIndex = (Integer)serializable;
            }
            if ((serializable = modelInfo.get("BridgePortSumm.BPortVBridge")) instanceof Integer) {
                this.vbridgeId = (Integer)serializable;
            }
            if ((serializable = modelInfo.get("BridgePortSumm.BPortState")) instanceof Integer) {
                this.stpState = (Integer)serializable;
            }
            if ((serializable = modelInfo.get("BridgePortSumm.BPortType")) instanceof Integer) {
                this.portType = (Integer)serializable;
            }
            this.key = String.valueOf(String.valueOf(this.slot)) + "." + String.valueOf(this.port);
            this.getPortStatusProxy();
        }

        protected LsBridgeObject getParentBridge() {
            return this.parent;
        }

        protected void setParentBridge(LsBridgeObject lsBridgeObject) {
            this.parent = lsBridgeObject;
        }

        protected void setVBridgeId(int n) {
            this.vbridgeId = n;
        }

        public int getSlot() {
            return this.slot;
        }

        public int getPort() {
            return this.port;
        }

        public int getIfIndex() {
            return this.ifIndex;
        }

        public int getVBridgeId() {
            return this.vbridgeId;
        }

        public int getStpState() {
            return this.stpState;
        }

        public int getPortType() {
            return this.portType;
        }

        public String getTranslatedPortType() {
            String string = null;
            try {
                String string2 = LsPortModel.PortInfo.PortTypeEnum.numericToSymbolic(this.portType);
                string = LsBridgeConfig.getEnumStrings().getString(string2);
            }
            catch (Exception exception) {
                string = String.valueOf(this.portType);
            }
            return string;
        }

        public String getKey() {
            return this.key;
        }

        public GenModel getBridgePortModel() {
            return this.parent.getBridgePortExtsModel();
        }

        public Status getPortStatusProxy() {
            block2: {
                if (this.portStatus != null) break block2;
                ModelInfo modelInfo = new ModelInfo();
                modelInfo.add("Index.Slot", new Integer(this.getSlot()));
                modelInfo.add("Index.Port", new Integer(this.getPort()));
                try {
                    RemoteStatus remoteStatus = LsBridgeConfig.this.access$1().getStatusRefForRow(modelInfo);
                    this.portStatus = new StatusProxy(remoteStatus);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return this.portStatus;
        }
    }

    private class RefreshThread
    extends Thread {
        public void run() {
            Vector vector = LsBridgeConfig.this.access$2();
            LsBridgeConfig.this.access$3(vector);
            LsBridgeConfig.this.access$4(false);
        }

        RefreshThread() {
            LsBridgeConfig.this = LsBridgeConfig.this;
        }
    }

    private class BuildDependentsThread
    extends Thread {
        public void run() {
            LsBridgeConfig.this.access$5();
        }

        BuildDependentsThread() {
            LsBridgeConfig.this = LsBridgeConfig.this;
        }
    }
}

